unit WinForm;

interface

uses
  System.Drawing,
  System.Drawing.Printing,
  System.ComponentModel,
  System.Windows.Forms,
  System.IO,
  Simp_Prn;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    components: System.ComponentModel.IContainer;
    PrintersCombo: System.Windows.Forms.ComboBox;
    Label1: System.Windows.Forms.Label;
    FinalDemoButton: System.Windows.Forms.Button;
                Lesson1Button: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure TestButton_Click(sender: System.Object; e: System.EventArgs);
    procedure TWinForm_Load(sender: System.Object; e: System.EventArgs);
                procedure Lesson1Button_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    procedure PrintTheReadme;
    procedure MultiTest;
    procedure PopulateInstalledPrintersCombo;
    procedure on_CreatePrintDocument(sender: System.Object; pd: PrintDocument);
    procedure on_PrintPage(sender: System.Object; ua: UserPrintPageEventArgs);

  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  public
    constructor Create;
  end;

implementation


{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
        Self.PrintersCombo := System.Windows.Forms.ComboBox.Create;
        Self.Label1 := System.Windows.Forms.Label.Create;
        Self.FinalDemoButton := System.Windows.Forms.Button.Create;
        Self.Lesson1Button := System.Windows.Forms.Button.Create;
        Self.SuspendLayout;
        //
        // PrintersCombo
        //
        Self.PrintersCombo.Location := System.Drawing.Point.Create(16, 24);
        Self.PrintersCombo.Name := 'PrintersCombo';
        Self.PrintersCombo.Size := System.Drawing.Size.Create(384, 21);
        Self.PrintersCombo.TabIndex := 0;
        Self.PrintersCombo.Text := 'ComboBox1';
        //
        // Label1
        //
        Self.Label1.Location := System.Drawing.Point.Create(8, 8);
        Self.Label1.Name := 'Label1';
        Self.Label1.Size := System.Drawing.Size.Create(100, 16);
        Self.Label1.TabIndex := 1;
        Self.Label1.Text := 'Printer Selection';
        //
        // FinalDemoButton
        //
        Self.FinalDemoButton.Location := System.Drawing.Point.Create(16, 104);
        Self.FinalDemoButton.Name := 'FinalDemoButton';
        Self.FinalDemoButton.Size := System.Drawing.Size.Create(152, 23);
        Self.FinalDemoButton.TabIndex := 2;
        Self.FinalDemoButton.Text := 'Run the Ultimate Demo';
        Include(Self.FinalDemoButton.Click, Self.TestButton_Click);
        //
        // Lesson1Button
        //
        Self.Lesson1Button.Location := System.Drawing.Point.Create(16, 56);
        Self.Lesson1Button.Name := 'Lesson1Button';
        Self.Lesson1Button.Size := System.Drawing.Size.Create(152, 23);
        Self.Lesson1Button.TabIndex := 3;
        Self.Lesson1Button.Text := 'Lesson1';
        Include(Self.Lesson1Button.Click, Self.Lesson1Button_Click);
        //
        // TWinForm
        //
        Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
        Self.ClientSize := System.Drawing.Size.Create(408, 141);
        Self.Controls.Add(Self.Lesson1Button);
        Self.Controls.Add(Self.FinalDemoButton);
        Self.Controls.Add(Self.Label1);
        Self.Controls.Add(Self.PrintersCombo);
        Self.Name := 'TWinForm';
        Self.Text := 'WinForm';
        Include(Self.Load, Self.TWinForm_Load);
        Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TWinForm.PopulateInstalledPrintersCombo;
VAR i: Integer;
    s: String;
begin
  //
  // Add list of installed printers found
  // on the computer to the combo box, for
  // the customers to be able to select
  //
  for i := 0 to Pred(PrinterSettings.InstalledPrinters.Count) do
    PrintersCombo.Items.Add(PrinterSettings.InstalledPrinters[i]);

  s := PrintDocument.Create().PrinterSettings.PrinterName;
  PrintersCombo.SelectedIndex := PrintersCombo.FindStringExact(s);
end;

procedure TWinForm.TWinForm_Load(sender: System.Object; e: System.EventArgs);
begin
  PopulateInstalledPrintersCombo();
end;

procedure TWinForm.Lesson1Button_Click(sender: System.Object; e: System.EventArgs);
begin
  PrintTheReadme();
end;

procedure TWinForm.TestButton_Click(sender: System.Object; e: System.EventArgs);
begin
  MultiTest();
end;

procedure TWinForm.on_CreatePrintDocument(sender: System.Object; pd: System.Drawing.Printing.PrintDocument);
begin
  // Use the selected printer
  //
  if (PrintersCombo.SelectedIndex <> -1) then
    pd.PrinterSettings.PrinterName := PrintersCombo.Text;
end;

procedure TWinForm.on_PrintPage(sender: System.Object; ua: UserPrintPageEventArgs);
VAR ev: PrintPageEventArgs;
begin
  // here is how to print page numbers...
  //
  (sender as SimplePrintout).Footer.Text := ('Page ' + ua.PageNo.ToString);

  // If the page is #2 we want to draw something
  // on the page. However we do not want to disable
  // the header and the footer. To disable header, or
  // footer you can use:
  //   "ua.HeaderHandledByUser := true;"
  //   "ua.FooterHandledByUser := true;"
  //
  // To cancel printing, use:
  //   "ua.PrintoutHandledByUser := true;"
  //
  // If you want to add a background image, or
  // background text to be overlayed by the printed
  // text, then use:
  //   "ua.BackgroundHandledByUser := true;"
  // rather than:
  //   "ua.PageHandledByUser := true;"
  //
  if (ua.PageNo = 2) then
  begin
    ua.PageHandledByUser := True;
    ev := ua.pageParms;
    ev.Graphics.PageUnit := GraphicsUnit.Inch;
    ev.Graphics.DrawString('User printed this in a callback (delegate)', System.Drawing.Font.Create('Arial', 20), Brushes.Black, 2, 2);
    ev.Graphics.FillRectangle(Brushes.Black, 3, 3, 2, 2);
    ev.Graphics.DrawString('BOX', System.Drawing.Font.Create('Arial', 26), Brushes.White, RectangleF.Create(3, 3, 2, 2));
  end;

  if (ua.PageNo = 3) then
  begin
    // three pages will suffice... stop wasting paper
    ua.PrintoutLastPage := True;
  end;
end;

procedure TWinForm.PrintTheReadme;
VAR p: SimplePrintout;
    s: StreamReader;
    filename: String;
begin
  filename := Path.GetDirectoryName(ParamStr(0))+'\readme.txt';

  // It's very simple to create
  // a SimplePrintout...
  //
  p := SimplePrintout.Create();

  try
    // Always call BeginPrintout!
    //
    p.BeginPrintout();

    // Use fixed font
    //
    p.Band.TextFont := System.Drawing.Font.Create('Courier New', 10);

    // And finally here is how to print out a text file...
    // This is much simpler than Microsoft .NET sample.
    //
    s := StreamReader.Create(filename);
    p.WriteString(s.ReadToEnd());
    s.Close();

    // Use this call to flush the text to the printer
    //
    p.EndPrintout();

    // NOTE: To cancel printout you may use
    //   p.AbortPrintout(); instead of p.EndPrintout();
    //
  except
    on E: Exception do
      MessageBox.Show(E.Message);
  end;
  p.Free; // with .NET you do not really need this one
end;

procedure TWinForm.MultiTest;
VAR p: SimplePrintout;
    s: StreamReader;
    filename: String;
begin
  p := SimplePrintout.Create();
  try
    Include(p.PrintPage, on_PrintPage);
    Include(p.CreatePrintDocument, on_CreatePrintDocument);
    p.BeginPrintout();

    // NOTE: headers and footers do not pay attention to margins,
    // so the header stays at the top while all the rest of
    // the text moves down by 1.5"
    p.TopMargin := 1.5; // leave some room for the header
    p.BottomMargin := 1; // leave some room for the footer

    // Here is how easy it is to set up
    // a footer and a header for your printout
    //
    p.Header.IndentLeft := 0.5;
    p.Header.IndentRight := 0.5;
    p.Footer.TextIndentTop := 0.3;
    p.Header.BorderPixelSize := 6;
    p.Header.Text := 'you can have'+#13#10+'multi-line HEADERS';

    p.Footer.TextIndentBottom := 0.3;
    p.Footer.Text := 'Footer text';

    // To align your paragraph text to Left,
    // simply set Band.TextAlignment to baLeft
    // (Your choices for alignment are:
    //  baLeft, baRight, baCentered, and baJustified
    //
    p.Band.TextAlignment := BandAlignment.baLeft;
    p.WriteString('Text aligned to Left...');
    p.WriteString();
    p.Band.TextFont := System.Drawing.Font.Create('Arial', 12);
    p.WriteString('Congratulations and thank you for using our SimplePrintout '+
                  'class. As you see, using SimplePrintout you can create '+
                  'sophisticated printouts with just a few lines of code.'+
                  'You are limited only by your imagination. .NET is made easy '+
                  'with this this versatile tool. Of course, you get the '+
                  'entire source code, so if you miss something you can easily '+
                  'improve on this ultimate tool to fit your needs.');

    // Band.IndentLeft and Band.IndentRight
    // are box indents (paragraph background
    // indents). They affect how the
    // background and borders are printed
    //
    p.Band.IndentLeft := 0;
    p.Band.IndentRight := 0;

    p.Band.TextAlignment := BandAlignment.baRight;
    p.WriteString('You can align your text to Right');

    // This is how you can change fonts.
    // It's pretty striaghtforward.
    //
    p.Band.TextFont := System.Drawing.Font.Create('Arial', 16);
    p.Band.TextAlignment := BandAlignment.baCentered;

    // To indicate a line break you can use CRLF
    //
    p.WriteString('You can change fonts'+#13#10+' and Center text as easily as 1-2-3'+#13#10+#13#10);
    p.Band.TextAlignment := BandAlignment.baJustified;
    p.WriteString('You may also justify text like this.');
    p.Band.TextAlignment := BandAlignment.baLeft;

    // To change the background color,
    // simply set Band.BackColor
    //
    p.Band.BackColor := Color.Red;
    p.WriteString('You may use colored backgrounds too');
    p.Band.BackColor := Color.White;
    p.Band.TextAlignment := BandAlignment.baCentered;
    p.Band.BorderPixelSize := 1;
    p.WriteString('You may use bordered text');
    p.Band.IndentLeft := 1;
    p.WriteString('You may use bordered text with border indent');
    p.Band.IndentLeft := 2;
    p.WriteString('You may use bordered text');
    p.Band.IndentLeft := 3;
    p.WriteString('You may use bordered text');

    // As you saw above IndentLeft and IndentRight
    // will move the border and the background along
    // with the text.
    // Use TextIndentLeft, TextIndentRight, etc.
    // to move the text and leave the border,
    // and the background intact:
    //
    p.Band.IndentLeft := 0;
    p.Band.TextIndentLeft := 1;
    p.WriteString('You may use bordered text with TEXT indent');
    p.Band.TextIndentLeft := 2;
    p.WriteString('You may use bordered text');
    p.Band.IndentLeft := 3;
    p.Band.IndentRight := 0.5;
    p.Band.BackColor := Color.Red;
    p.WriteString('Indented text with color background');
    p.Band.BackColor := Color.White;
    p.Band.BorderPixelSize := 0;

    p.Band.IndentLeft := 0;
    p.Band.IndentRight := 0;
    // This is how you insert an empty string:
    //
    p.WriteString();
    p.Band.TextIndentLeft := 3;
    p.Band.TextIndentRight := 0.5;
    p.Band.BackColor := Color.Red;
    p.Band.TextAlignment := BandAlignment.baLeft;
    p.WriteString('This is a very long string and let us see if it will wrap itself around. Wrap1 Wrap2');

    p.Band.IndentLeft := 0;
    p.Band.IndentRight := 0;
    p.Band.TextIndentLeft := 0;
    p.Band.TextIndentRight := 0;
    p.WriteString('This is a very long string and let us see if it will wrap itself around. Wrap1 Wrap2');
    p.Band.BackColor := Color.White;
    p.Band.BorderPixelSize := 0;

    p.WriteString();
    // And finally here is how to print out a text file...
    //
    p.Band.Transparent := true;
    filename := Path.GetDirectoryName(ParamStr(0))+'\readme.txt';
    s := StreamReader.Create(filename);
    p.WriteString(s.ReadToEnd());
    s.Close();

    p.EndPrintout();
  except
    on E: Exception do
      MessageBox.Show(E.Message);
  end;
  p.Free;
end;

end.
